package benchmarks;

import java.io.IOException;

import com.google.caliper.Runner;
import com.google.caliper.SimpleBenchmark;

import edu.vub.at.actors.natives.Packet;
import edu.vub.at.exceptions.InterpreterException;
import edu.vub.at.exceptions.XIOProblem;


/**
 * Times the serialisation and deserialization time of different AmbienTtalk objects with the Kryo implementation of the AmbientTalk interpreter.
 * @author cbassem
 *
 */
public class Benchmark extends SimpleBenchmark {
	
	private static TestClasses objects;
		
	public static String resultsPath = "Results/";
	
	//{"TXTSerialization", "TXTDeserialization", "CoercerSerialization", "CoercerDeserialization", "IsoleteSerialization", "IsoleteDeserialization", "NATTable10Serialization", "NATTable10Deserialization", "NATTable100Serialization", "NATTable100Deserialization"};
	public static String[] benchmarkMethods = {"TXTSerialization", "TXTDeserialization", "CoercerSerialization", "CoercerDeserialization", "IsoleteSerialization", "IsoleteDeserialization", "NATTable10Serialization", "NATTable10Deserialization", "NATTable100Serialization", "NATTable100Deserialization"};
	
	@Override
	protected void setUp() throws InterpreterException, IOException,
			IllegalAccessException, ClassNotFoundException,
			InstantiationException {

		objects = new TestClasses();
	}

	public void timeTXTSerialization(int reps) throws IOException, XIOProblem {
		for (int i = 0; i < reps; ++i) {
			new Packet("test", objects.boeTXT);
		}
	}
	
	public void timeTXTDeserialization(int reps) throws IOException, InterpreterException {
		for (int i = 0; i < reps; ++i) {
			objects.serializedBoeTXT.unpack();
		}
	}
	
	public void timeCoercerSerialization(int reps) throws IOException, XIOProblem {
		for (int i = 0; i < reps; ++i) {
			new Packet("test", objects.coercer);
		}
	}
	
	public void timeCoercerDeserialization(int reps) throws IOException, InterpreterException {
		for (int i = 0; i < reps; ++i) {
			objects.serializedCoercer.unpack();
		}
	}
	
	public void timeIsoleteSerialization(int reps) throws IOException, XIOProblem {
		for (int i = 0; i < reps; ++i) {
			new Packet("test", objects.isolete);
		}
	}
	
	public void timeIsoleteDeserialization(int reps) throws IOException, InterpreterException {
		for (int i = 0; i < reps; ++i) {
			objects.serializedIsolet.unpack();
		}
	}
	
	public void timeNATTable10Serialization(int reps) throws IOException, XIOProblem {
		for (int i = 0; i < reps; ++i) {
			new Packet("test", objects.natTable10);
		}
	}
	
	public void timeNATTable10Deserialization(int reps) throws IOException, InterpreterException {
		for (int i = 0; i < reps; ++i) {
			objects.serializedNATTable10.unpack();
		}
	}
	
	public void timeNATTable100Serialization(int reps) throws IOException, XIOProblem {
		for (int i = 0; i < reps; ++i) {
			new Packet("test", objects.natTable100);
		}
	}
	
	public void timeNATTable100Deserialization(int reps) throws IOException, InterpreterException {
		for (int i = 0; i < reps; ++i) {
			objects.serializedNATTable100.unpack();
		}
	}
	
	/**
	 * @param args
	 * @throws IOException 
	 * @throws InterpreterException 
	 */
	public static void main(String[] args) throws InterpreterException, IOException {
		String methods = "";

		methods += benchmarkMethods[0];
		for(int i = 1; i < benchmarkMethods.length; i++){
			methods += "," + (benchmarkMethods[i]);
		}

		Runner.main(Benchmark.class, new String[] {"-Dbenchmark=" + methods,"-JmemoryMax=-Xmx2G", "--timeUnit", "ns", "--saveResults", resultsPath, "--trials", "40"});
	}

}
